/////////////////////////////////////////////////////////////
//	File	:	"CNote.h"
//
//	Author	:	Alyssa Dettling (AD)
//
//	Purpose	:	Defines a note object for the game
/////////////////////////////////////////////////////////////

#ifndef CNOTE_H_
#define CNOTE_H_

#include "CBase.h"
#include "IListener.h"

class CNote : public CBase
{
	//determines if this is a quarter note or an eigth note
	int m_nNoteType;
	bool m_bIsHit;
	int m_nBadDeadID, m_nGoodDeadID;

	//Number to find sin of
	float m_nSin;

	//the base Y Position
	float startYPos;

public:
	enum { QUARTER_NOTE = 0, EIGHTH_NOTE, NUM_NOTES};

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Constructor
	//
	//  Purpose : Initializes the data in the object.
	///////////////////////////////////////////////////////////////////////////////////
	CNote(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Destructor
	//
	//  Purpose : Cleans up any dynamic memory.
	///////////////////////////////////////////////////////////////////////////////////
	virtual ~CNote(void);

	///////////////////////////////////////////////////
	//	Function:	Accessors
	//
	//	Purpose: Gets the specified type
	///////////////////////////////////////////////////
	inline int GetNoteType() const {return m_nNoteType;}
	inline bool GetIsHit(void) const {return m_bIsHit; }
	

	
	//////////////////////////////////
	//	Function:	Mutators
	//
	//	Purpose: Sets the specified type
	/////////////////////////////////
	inline void SetStartY(float Y) {startYPos = Y;}
	inline void SetIsHit(bool bIsHit) { m_bIsHit = bIsHit; }
	inline void SetNoteType(int nNoteType)
	{
		if(nNoteType >= NUM_NOTES)
			nNoteType = NUM_NOTES-1;

		m_nNoteType = nNoteType;
	}

	///////////////////////////////////////////////////////////////////////////////
	//	Function:	"Update"
	//
	//	Purpose:	Updates the objects position based on its velocity
	///////////////////////////////////////////////////////////////////////////////
	virtual void Update(float fElapsedTime);

	///////////////////////////////////////////////////////////////////////////////
	//	Function:	Render
	//
	//	Purpose:	Renders the object
	///////////////////////////////////////////////////////////////////////////////
	void Render(void);

	///////////////////////////////////////////////////////////////////////////////
	//	Function:	CheckCollisions
	//
	//	Purpose:	Checked collisions on this object against every other object.
	///////////////////////////////////////////////////////////////////////////////
	virtual bool CheckCollisions(CBase * pBase);

	/////////////////////////////////
	//	Function:	HandleEvent
	//  Last Modified: July 23, 2008
	//	Purpose: handles an event
	/////////////////////////////////
	void HandleEvent(CEvent* pEvent);
};
#endif


